/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.mentalstate;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.mentalstate.IMentalState;
import edu.mit.semantics.core.rep.valence.Valence;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Data;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.rep.IHasRep;

public class MentalState
extends Data
implements IMentalState {
    private final Valence value;
    private final IDesc charDesc;
    private final IDesc eventDesc;

    public MentalState(Valence value, IDesc charDesc, IDesc eventDesc) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (!CorefRep.getInstance().isType((IHasRep)charDesc)) {
            throw new IllegalArgumentException();
        }
        if (!EventRep.getInstance().isType((IHasRep)eventDesc)) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        this.charDesc = charDesc;
        this.eventDesc = eventDesc;
    }

    public Valence getValence() {
        return this.value;
    }

    public IDesc getCharacter() {
        return this.charDesc;
    }

    public IDesc getEvent() {
        return this.eventDesc;
    }

    public IHasPosition calculatePosition() {
        return PositionUtils.combine((IHasPosition)this.charDesc, (IHasPosition)this.eventDesc);
    }

    public IHasPosition getDisplayPosition() {
        return this.eventDesc;
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDesc newCharDesc = model.getData().getDescriptions(CorefRep.getInstance()).getDescription(this.charDesc.getID());
        if (newCharDesc == null) {
            return null;
        }
        IDesc newEventDesc = model.getData().getDescriptions(EventRep.getInstance()).getDescription(this.eventDesc.getID());
        if (newEventDesc == null) {
            return null;
        }
        if (this.charDesc == newCharDesc && this.eventDesc == newEventDesc) {
            return this;
        }
        return new MentalState(this.value, this.charDesc, this.eventDesc);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        IMentalState tgt = (IMentalState)tgtData;
        if (this.value != tgt.getValence()) {
            return false;
        }
        if (!this.charDesc.equals(tgt.getCharacter(), model)) {
            return false;
        }
        return this.eventDesc.equals(tgt.getEvent(), model);
    }
}

