/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.label;

import edu.mit.jwi.item.IWord;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.evidence.EvidenceType;
import edu.mit.wordnet.ui.WordnetUIPlugin;
import edu.mit.wordnet.ui.content.SenseContentProvider;
import java.util.Iterator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class SenseLabelProvider
extends StoryModelLabelProvider {
    private Image senseImg;
    private Image monoImg;
    private Image ambiguousImg;
    private Image lemmaImg;

    public SenseLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof SenseContentProvider.StemDescSet) {
            SenseContentProvider.StemDescSet ds = (SenseContentProvider.StemDescSet)((Object)element);
            StyledString result = new StyledString();
            result.append(ds.getStem());
            result.append(" " + ds.getTag().toGenericTag().getTagString(), StyledString.COUNTER_STYLER);
            if (ds.isAuxiliary()) {
                result.append(" (aux)", StyledString.COUNTER_STYLER);
            }
            boolean same = !ds.isEmpty();
            IWord last = ((ISense)ds.first().getData()).getSense();
            Iterator iterator = ds.iterator();
            while (iterator.hasNext()) {
                IDesc d = (IDesc)iterator.next();
                ISense sense = (ISense)d.getData();
                if (last == sense.getSense()) continue;
                same = false;
                break;
            }
            if (same) {
                result.append(" " + this.getTextForSense(last), StyledString.DECORATIONS_STYLER);
            }
            return result;
        }
        if (element instanceof IDescSet) {
            IDescSet senseDescs = (IDescSet)element;
            ISense sense = (ISense)((IDesc)senseDescs.first()).getData();
            IBaseToken token = (IBaseToken)sense.getWord().getData();
            return new StyledString(token.getSurface());
        }
        if (element instanceof IDesc) {
            IDesc senseDesc = (IDesc)element;
            ISense sense = (ISense)senseDesc.getData();
            String senseStr = this.getTextForSense(sense.getSense());
            StyledString result = this.getStyledTextForWord(sense.getWord(), sense.getPOSDesc(), sense.getStemDesc(), senseDesc);
            result.append(' ');
            result.append(senseStr, StyledString.DECORATIONS_STYLER);
            return SenseLabelProvider.appendMergeTags((StyledString)result, (IDesc)senseDesc);
        }
        return super.getStyledText(element);
    }

    protected StyledString getStyledTextForWord(IDesc tokenDesc, IDesc posDesc, IDesc stemDesc, IDesc idDesc) {
        IBaseToken token = (IBaseToken)tokenDesc.getData();
        IPosTag pos = posDesc == null ? null : (IPosTag)posDesc.getData();
        IStem stem = stemDesc == null ? null : (IStem)stemDesc.getData();
        StyledString result = new StyledString();
        result.append(token.getSurface());
        if (stem != null) {
            result.append(" (", StyledString.QUALIFIER_STYLER);
            result.append(stem.getStem(), StyledString.QUALIFIER_STYLER);
            result.append(')', StyledString.QUALIFIER_STYLER);
        }
        String posStr = pos == null ? "POS?" : pos.getTag().getTagString();
        result.append(String.valueOf(' ') + posStr, StyledString.COUNTER_STYLER);
        result.append(" (", StyledString.DECORATIONS_STYLER);
        result.append(Long.toString(idDesc.getID()), StyledString.DECORATIONS_STYLER);
        result.append(')', StyledString.DECORATIONS_STYLER);
        return result;
    }

    protected String getTextForSense(IWord sense) {
        if (sense == null) {
            return "(no sense)";
        }
        return sense.getSenseKey().toString();
    }

    public Image getImage(Object element) {
        if (element instanceof SenseContentProvider.StemDescSet) {
            return this.getLemmaImg();
        }
        if (element instanceof IDescSet) {
            return this.getAmbiguousWordImg();
        }
        if (element instanceof IDesc) {
            IDesc d = (IDesc)element;
            ISense s = (ISense)d.getData();
            if (s.getEvidence() != null && s.getEvidence().getType() == EvidenceType.MONOSEM) {
                return this.getMonoSenseImg();
            }
            return this.getSenseImg();
        }
        return super.getImage(element);
    }

    protected Image getSenseImg() {
        if (this.senseImg == null) {
            this.senseImg = WordnetUIPlugin.getDefault().getImageRegistry().get("obj16/sense.gif");
        }
        return this.senseImg;
    }

    protected Image getMonoSenseImg() {
        if (this.monoImg == null) {
            this.monoImg = WordnetUIPlugin.getDefault().getImageRegistry().get("obj16/monosemous.gif");
        }
        return this.monoImg;
    }

    protected Image getAmbiguousWordImg() {
        if (this.ambiguousImg == null) {
            this.ambiguousImg = WordnetUIPlugin.getDefault().getImageRegistry().get("obj16/word_ambiguous.gif");
        }
        return this.ambiguousImg;
    }

    protected Image getLemmaImg() {
        if (this.lemmaImg == null) {
            this.lemmaImg = WordnetUIPlugin.getDefault().getImageRegistry().get("obj16/lemma.gif");
        }
        return this.lemmaImg;
    }
}

