/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadOutputStream;
import org.eclipse.help.internal.webapp.servlet.FilterUtils;
import org.eclipse.help.internal.webapp.servlet.IFilter;

public class ShowInTocFilter
implements IFilter {
    private static final String scriptPart1 = "\n<script type=\"text/javascript\" src=\"";
    private static final String scriptPart3 = "advanced/synchWithToc.js\"></script>";

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        String uri = req.getRequestURI();
        if (uri == null) {
            return out;
        }
        if (!(uri.endsWith("html") || uri.endsWith("htm") || UrlUtil.isNavPath(uri))) {
            return out;
        }
        if ("/nftopic".equals(req.getServletPath()) || "/ntopic".equals(req.getServletPath()) || "/rtopic".equals(req.getServletPath()) || UrlUtil.isBot(req)) {
            return out;
        }
        String noframes = req.getParameter("noframes");
        if ("true".equals(noframes)) {
            return out;
        }
        String path = req.getPathInfo();
        if (path == null) {
            return out;
        }
        StringBuffer script = new StringBuffer(scriptPart1);
        String relativePath = FilterUtils.getRelativePathPrefix(req);
        script.append(relativePath);
        script.append(scriptPart3);
        try {
            return new FilterHTMLHeadOutputStream(out, script.toString().getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return out;
        }
    }
}

