/* Filename: IndicationStructureLabelProvider.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 23/09/2009
 */
package nil.ucm.indications2.ui.label;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.IModifier;
import nil.ucm.indications2.core.rep.INucleus;
import nil.ucm.indications2.core.rep.IndicationStructureRep;
import nil.ucm.indications2.core.rep.IndicationType;
import nil.ucm.indications2.core.rep.model.IIndicationStructureModel;
import nil.ucm.indications2.ui.IndicationsUIConstants;
import nil.ucm.indications2.ui.IndicationsUIPlugin;
import nil.ucm.indications2.ui.content.IndicationStructureContentProvider.ReferentReferencePair;
import nil.ucm.indications2.ui.content.IndicationStructureContentProvider.TypedModifierList;
import nil.ucm.indications2.ui.content.IndicationStructureContentProvider.TypedNucleusList;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;

/** 
 * TODO: Write comment
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 05, 2010)
 * @since nil.ucm.indications.ui 1.0.0
 */
public class IndicationStructureLabelProvider extends StoryModelLabelProvider implements IColorProvider {
	
	public IndicationStructureLabelProvider(IStoryEditor editor) {
		super(editor);
	}
	
	/* 
	 * (non-Javadoc) @see org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider#getStyledText(java.lang.Object)
	 */
	@Override
	public StyledString getStyledText(Object element) {
	
		if (element instanceof IIndicationStructureModel) {
			
			IIndicationStructureModel model = ((IIndicationStructureModel)element);
			StyledString s = new StyledString(model.getReference().getDisplayText());
			if(model.isCopularPredicate()) s.append(" - Copular Predicate", StyledString.DECORATIONS_STYLER);
//			String styleStr = getStringFromType(model.getType());
			
//			s.append(" - " + styleStr, StyledString.DECORATIONS_STYLER);
			return s;
		}
		
		//Handle indication structure description
		if (element instanceof IDesc && IndicationStructureRep.getInstance().isType((IHasRep)element)) {
			
			IDesc desc = (IDesc)element;
			IIndicationStructure indStruct = (IIndicationStructure)desc.getData();
			StyledString s = new StyledString(indStruct.getReference().getDisplayText());

//			String styleStr = getStringFromType(indStruct.getType());
			
			s.append(" (" + desc.getID() + ")", StyledString.DECORATIONS_STYLER);
			if(indStruct.isCopularPredicate()) s.append(" - Copular Predicate", StyledString.DECORATIONS_STYLER);

//			s.append(" - " + styleStr, StyledString.DECORATIONS_STYLER);
			return s;
		}
		
		//Handle referent
		if(element instanceof ReferentReferencePair) {
			ReferentReferencePair pair = (ReferentReferencePair)element;
			IDesc desc = pair.getReferentDesc();
			IReferent ref = (IReferent)desc.getData();
			IReference reference = pair.getReference();
			
			StyledString s = new StyledString(ref.getName());
			s.append(" " + desc.getID() + " - " + reference.getID(), StyledString.DECORATIONS_STYLER);
			return s;
		}
		
		//Handle nuclei
		if(element instanceof TypedNucleusList){
			return new StyledString("(nuclei)", StyledString.COUNTER_STYLER);
		}
		
		//Handle modifiers
		if(element instanceof TypedModifierList){
			return new StyledString("(modifiers)", StyledString.COUNTER_STYLER);
		}
		
		//Handle single nucleus
		if (element instanceof INucleus) {
			INucleus nuc = (INucleus)element;
			StyledString s = new StyledString(nuc.getDisplayText());
			s.append(" - " + getStringFromType(nuc.getType()), StyledString.DECORATIONS_STYLER);
			return s;
		}
		
		//Handle single modifier
		if (element instanceof IModifier) {
			IModifier mod = (IModifier)element;
			StyledString s = new StyledString(mod.getDisplayText());
			s.append(" - " + getStringFromType(mod.getType()), StyledString.DECORATIONS_STYLER);
			return s;
		}
		
		return super.getStyledText(element);
	}
	
	private String getStringFromType(IndicationType type) {
		
		String styleStr;
		switch (type) {
			case DESCRIPTIVE : styleStr = "Descriptive";break;
			case DISTINCTIVE : styleStr = "Distinctive";break;
			case OTHER : styleStr = "Other";break;
			default : styleStr = "Unknown"; break;
		}
		return styleStr;
	}
	
	public Image getImage(Object element) {
		
		if (element instanceof IDesc && IndicationStructureRep.getInstance().isType((IHasRep)element)) {
			return IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_Reference);
		}
		
		if (element instanceof IIndicationStructure) {
			return IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_Reference);
			
		}
		
		if(element instanceof ReferentReferencePair) {
			return IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_Referent);
		}
		
		if(element instanceof INucleus) {
			return IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_Nucleus);
		}
		
		if(element instanceof IModifier) {
			return IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_Modifier);
		}
		
		if(element instanceof TypedNucleusList) {
			return IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_NucleusList);
		}
		
		if(element instanceof TypedModifierList) {
			return IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_ModifierList);
		}
		
		return super.getImage(element);
	}
	
}
