/* Filename: MoveReferenceChange.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: May 3, 2010
 */
package edu.mit.discourse.core.rep.referent.change;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import edu.mit.discourse.core.DiscourseMessages;
import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class MoveReferenceChange extends AbstractModelChange {
	
	private Map<IModelChange, IModelChange> changeMap;
	
	public MoveReferenceChange(Map<IReference, IDesc> refs, IDesc target, ITiming timing) {
		super(DiscourseMessages.CHANGE_MoveReference_name);
		Map<IModelChange, IModelChange> changes = new HashMap<IModelChange, IModelChange>(refs.size());
		IModelChange remove, add;
		for(Entry<IReference, IDesc> entry : refs.entrySet()){
			remove = new RemoveReferenceChange(entry.getKey(), entry.getValue(), timing);
			add = new AddReferenceChange(Collections.singleton(entry.getKey().getSegments()), target, timing);
			changes.put(remove, add);
		}
		changeMap = Collections.unmodifiableMap(changes);
		
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.model.change.AbstractModelChange#doApply(java.lang.Object, edu.mit.story.core.model.IMutableStoryModel)
	 */
	@Override
	protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
		StoryChangeEventIntegrator integrator = new StoryChangeEventIntegrator(source, model);
		StoryChangeEvent e;
		for(Entry<IModelChange, IModelChange> entry : changeMap.entrySet()){
			e = entry.getKey().apply(source, model);
			if(e != null){
				integrator.addEvent(e);
				e = entry.getValue().apply(source, model);
				integrator.addEvent(e);
			}
		}
		return integrator.asEvent();
	}

}
