/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.MessageFormat;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.CopySource;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.ProgressListener;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNAdmin;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlProgressListener;

public class JhlClientAdapter
extends AbstractJhlClientAdapter {
    private SVNAdmin svnAdmin;

    public JhlClientAdapter() {
        this.svnClient = new SVNClient();
        this.svnAdmin = new SVNAdmin();
        this.notificationHandler = new JhlNotificationHandler();
        this.progressListener = new JhlProgressListener();
        this.svnClient.notification2((Notify2)this.notificationHandler);
        this.svnClient.setPrompt((PromptUserPassword)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
        this.svnClient.setProgressListener((ProgressListener)this.progressListener);
    }

    public boolean isThreadsafe() {
        return true;
    }

    public static boolean isAvailable() {
        return JhlClientAdapterFactory.isAvailable();
    }

    public static String getLibraryLoadErrors() {
        return JhlClientAdapterFactory.getLibraryLoadErrors();
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        try {
            String fsType = repositoryType == null ? "fsfs" : repositoryType;
            this.notificationHandler.setCommand(23);
            String target = JhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine(MessageFormat.format("create --fstype {0} {1}", fsType, target));
            this.svnAdmin.create(target, false, false, null, fsType);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException((Throwable)e);
        }
    }

    public static void enableLogging(int logLevel, File filePath) {
        SVNClient.enableLogging((int)logLevel, (String)JhlClientAdapter.fileToSVNPath(filePath, false));
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }

    public void move(File srcPath, File destPath, boolean force) throws SVNClientException {
        ISVNProperty prop;
        if (srcPath.isFile() && (prop = this.propertyGet(srcPath, "svn:keywords")) != null) {
            try {
                this.notificationHandler.setCommand(5);
                String src = JhlClientAdapter.fileToSVNPath(srcPath, false);
                String dest = JhlClientAdapter.fileToSVNPath(destPath, false);
                this.notificationHandler.logCommandLine("move " + src + ' ' + dest);
                this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])new File[]{srcPath, destPath}));
                CopySource[] copySources = new CopySource[]{new CopySource(src, Revision.WORKING, Revision.WORKING)};
                this.svnClient.copy(copySources, dest, null, true, true, null);
                try {
                    this.overwriteFile(srcPath, destPath);
                }
                catch (IOException iOException) {}
                String[] paths = new String[]{src};
                this.svnClient.remove(paths, null, true, false, null);
            }
            catch (ClientException e) {
                this.notificationHandler.logException((Exception)((Object)e));
                throw new SVNClientException((Throwable)e);
            }
            return;
        }
        super.move(srcPath, destPath, force);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void overwriteFile(File srcFile, File destFile) throws IOException {
        AbstractInterruptibleChannel destination;
        block5: {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            FileChannel source = null;
            destination = null;
            try {
                source = new FileInputStream(srcFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                ((FileChannel)destination).transferFrom(source, 0L, source.size());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (source != null) {
                    source.close();
                }
                if (destination == null) throw throwable;
                destination.close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (source == null) break block5;
            }
            source.close();
        }
        if (destination == null) return;
        destination.close();
    }

    public String getNativeLibraryVersionString() {
        return this.svnClient.getVersion().toString();
    }
}

