/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Maps {
    public static void putIntoValueHashSet(Map map, Object key, Object value) {
        Maps.putIntoValueCollection(map, key, value, CollectionFactory.HASH_SET_FACTORY);
    }

    public static void putIntoValueArrayList(Map map, Object key, Object value) {
        Maps.putIntoValueCollection(map, key, value, CollectionFactory.ARRAY_LIST_FACTORY);
    }

    public static void putIntoValueCollection(Map map, Object key, Object value, CollectionFactory cf) {
        Collection c = (Collection)map.get(key);
        if (c == null) {
            c = cf.newCollection();
            map.put(key, c);
        }
        c.add(value);
    }

    public static Map compose(Map map1, Map map2) {
        HashMap composedMap = new HashMap();
        for (Object key : map1.keySet()) {
            composedMap.put(key, map2.get(map1.get(key)));
        }
        return composedMap;
    }

    public static Map invert(Map map) {
        HashMap invertedMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            invertedMap.put(value, key);
        }
        return invertedMap;
    }

    public static Map invertSet(Map map) {
        HashMap invertedMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Maps.putIntoValueHashSet(invertedMap, value, key);
        }
        return invertedMap;
    }

    public static void main(String[] args) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("a", "1");
        map1.put("b", "2");
        map1.put("c", "2");
        map1.put("d", "4");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("1", "x");
        map2.put("2", "y");
        map2.put("3", "z");
        System.out.println("map1: " + map1);
        System.out.println("invert(map1): " + Maps.invert(map1));
        System.out.println("invertSet(map1): " + Maps.invertSet(map1));
        System.out.println("map2: " + map2);
        System.out.println("compose(map1,map2): " + Maps.compose(map1, map2));
        HashMap setValues = new HashMap();
        HashMap listValues = new HashMap();
        Maps.putIntoValueArrayList(listValues, "a", "1");
        Maps.putIntoValueArrayList(listValues, "a", "1");
        Maps.putIntoValueArrayList(listValues, "a", "2");
        Maps.putIntoValueHashSet(setValues, "a", "1");
        Maps.putIntoValueHashSet(setValues, "a", "1");
        Maps.putIntoValueHashSet(setValues, "a", "2");
        System.out.println("listValues: " + listValues);
        System.out.println("setValues: " + setValues);
    }
}

