/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.text;

import edu.mit.story.core.rep.text.IndexedTextType;
import edu.mit.story.core.rep.text.TextRegion;
import org.eclipse.jface.text.ITextStore;

public class RegionTokenizer {
    static final char STAR = '*';
    static final char SLASH = '/';
    static final char NEWLINE = '\n';

    public static IndexedTextType findNextRegion(int index, ITextStore store) {
        if (index < 0 | store.getLength() <= index) {
            return null;
        }
        if (index == store.getLength() - 1) {
            return new IndexedTextType(index, 1, TextRegion.TEXT);
        }
        State state = RegionTokenizer.nextState(State.TEXT, store.get(index));
        TextRegion type = (state = RegionTokenizer.nextState(state, store.get(index + 1))) == State.SLASH_SECOND ? TextRegion.SINGLE : (state == State.STAR_BEGIN ? TextRegion.MULTI : TextRegion.TEXT);
        int idx = index;
        int end = -1;
        int slash = -1;
        state = State.TEXT;
        while (idx < store.getLength()) {
            state = RegionTokenizer.nextState(state, store.get(idx));
            if (type == TextRegion.TEXT) {
                if (state == State.TEXT) {
                    end = idx + 1;
                }
                if (state == State.SLASH_FIRST) {
                    end = idx + 1;
                    slash = idx;
                }
                if (state == State.SLASH_SECOND | state == State.STAR_BEGIN) {
                    end = slash;
                    break;
                }
            } else if (type == TextRegion.SINGLE) {
                if (state == State.NEWLINE) {
                    end = idx + 1;
                }
                if (state == State.STAR_BEGIN | state == State.TEXT) {
                    break;
                }
            } else if (type == TextRegion.MULTI && state == State.SLASH_END) {
                end = idx + 1;
                break;
            }
            ++idx;
        }
        if (end == -1) {
            end = idx;
        }
        return new IndexedTextType(index, end - index, type);
    }

    public static State nextState(State state, char next) {
        if (state == State.TEXT) {
            if (next == '/') {
                return State.SLASH_FIRST;
            }
            return State.TEXT;
        }
        if (state == State.SLASH_FIRST) {
            if (next == '/') {
                return State.SLASH_SECOND;
            }
            if (next == '*') {
                return State.STAR_BEGIN;
            }
            return State.TEXT;
        }
        if (state == State.SLASH_SECOND) {
            if (next == '\n') {
                return State.NEWLINE;
            }
            return State.SINGLE_BODY;
        }
        if (state == State.SINGLE_BODY) {
            if (next == '\n') {
                return State.NEWLINE;
            }
            return State.SINGLE_BODY;
        }
        if (state == State.NEWLINE) {
            if (next == '/') {
                return State.SLASH_FIRST;
            }
            if (next == '\n') {
                return State.TEXT;
            }
            if (Character.isWhitespace(next)) {
                return State.POST_SINGLE_WHITESPACE;
            }
            return State.TEXT;
        }
        if (state == State.POST_SINGLE_WHITESPACE) {
            if (next == '/') {
                return State.SLASH_FIRST;
            }
            if (next == '\n') {
                return State.TEXT;
            }
            if (Character.isWhitespace(next)) {
                return State.POST_SINGLE_WHITESPACE;
            }
            return State.TEXT;
        }
        if (state == State.STAR_BEGIN) {
            if (next == '*') {
                return State.STAR_END;
            }
            return State.MULTI_BODY;
        }
        if (state == State.MULTI_BODY) {
            if (next == '*') {
                return State.STAR_END;
            }
            return State.MULTI_BODY;
        }
        if (state == State.STAR_END) {
            if (next == '/') {
                return State.SLASH_END;
            }
            return State.MULTI_BODY;
        }
        if (state == State.SLASH_END) {
            if (next == '/') {
                return State.SLASH_FIRST;
            }
            return State.TEXT;
        }
        return state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        TEXT("text"),
        SLASH_FIRST("slash_first"),
        SLASH_SECOND("slash_second"),
        SINGLE_BODY("single_body"),
        NEWLINE("newline"),
        POST_SINGLE_WHITESPACE("post_single_whitespace"),
        STAR_BEGIN("star_begin"),
        MULTI_BODY("multi_body"),
        STAR_END("star_end"),
        SLASH_END("slash_end");

        private String fName;

        private State(String text) {
            this.fName = text;
        }

        public String toString() {
            return this.fName;
        }
    }
}

