/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.notify;

import javax.swing.event.ChangeListener;

public class ChangeListenerList {
    private static final ChangeListener[] EmptyArray = new ChangeListener[0];
    private volatile ChangeListener[] listeners = EmptyArray;

    public synchronized void add(ChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i = 0;
        while (i < oldSize) {
            if (listener == this.listeners[i]) {
                return;
            }
            ++i;
        }
        ChangeListener[] newListeners = new ChangeListener[oldSize + 1];
        System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
        newListeners[oldSize] = listener;
        this.listeners = newListeners;
    }

    public ChangeListener[] getListeners() {
        return this.listeners;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void remove(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i = 0;
        while (i < oldSize) {
            ChangeListener listener2 = this.listeners[i];
            if (listener == listener2) {
                if (oldSize == 1) {
                    this.listeners = EmptyArray;
                } else {
                    ChangeListener[] newListeners = new ChangeListener[oldSize - 1];
                    System.arraycopy(this.listeners, 0, newListeners, 0, i);
                    System.arraycopy(this.listeners, i + 1, newListeners, i, oldSize - i - 1);
                    this.listeners = newListeners;
                }
                return;
            }
            ++i;
        }
    }

    public int size() {
        return this.listeners.length;
    }

    public synchronized void clear() {
        this.listeners = EmptyArray;
    }
}

