/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.manager;

import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.manager.IManager;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.core.util.NameComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerUtils
implements IUtilityClass {
    public static Map<String, String> extractNameToIDMap(IManager<?> manager) {
        ArrayList descs = new ArrayList(manager.getDescriptors());
        Collections.sort(descs, NameComparator.getInstance());
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (IDescriptor desc : descs) {
            result.put(ManagerUtils.extractName(desc), desc.getID());
        }
        return result;
    }

    public static Map<String, String> extractNameToDescMap(IManager<?> manager) {
        ArrayList descs = new ArrayList(manager.getDescriptors());
        Collections.sort(descs, NameComparator.getInstance());
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (IDescriptor desc : descs) {
            result.put(ManagerUtils.extractName(desc), desc.getDescription());
        }
        return result;
    }

    public static String extractName(IDescriptor desc) {
        return String.valueOf(desc.getName()) + " (" + desc.getID() + ")";
    }
}

