/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.algorithm;

import edu.mit.story.core.algorithm.IAlgorithm;
import edu.mit.story.core.algorithm.IAlgorithmManager;
import edu.mit.story.core.descriptor.ICreatableDescriptor;
import edu.mit.story.core.descriptor.IRegisteredDescriptor;
import edu.mit.story.core.descriptor.RegisterableDescriptor;
import edu.mit.story.core.manager.CreatableManager;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmManager<A extends IAlgorithm>
extends CreatableManager<A, ICreatableDescriptor<A>>
implements IAlgorithmManager<A> {
    private final String extPointID;
    private final String elementName;

    public AlgorithmManager(String extPointID) {
        this(extPointID, "algorithm");
    }

    public AlgorithmManager(String extPointID, String elementName) {
        if (extPointID.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        if (elementName.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        this.extPointID = extPointID;
        this.elementName = elementName;
    }

    @Override
    protected boolean doInit() {
        for (IConfigurationElement element : AlgorithmManager.getElements(this.extPointID, this.elementName)) {
            IRegisteredDescriptor<A> d = this.createDescriptor(element);
            if (d == null) continue;
            this.registerDescriptor(d);
        }
        return true;
    }

    protected IRegisteredDescriptor<A> createDescriptor(IConfigurationElement element) {
        return new RegisterableDescriptor(element);
    }

    @Override
    public String getExtensionPointID() {
        return this.extPointID;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }
}

