/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.label;

import edu.mit.parsing.core.rep.tag.ITagData;
import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.tagset.ITag;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.ui.ParsingUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class TagDataLabelProvider
extends StoryModelLabelProvider {
    private Image tagImg;

    public TagDataLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public TagDataLabelProvider(IHasStoryEditor editorProvider) {
        super(editorProvider);
    }

    public StyledString getStyledText(Object element) {
        IDesc desc = null;
        if (element instanceof IDesc) {
            IDesc iDesc = desc = element instanceof IDesc ? (IDesc)element : null;
            if (TagRep.getInstance().isType((IHasRep)desc)) {
                element = desc.getData();
            }
        }
        if (element instanceof ITagData) {
            ITag tag;
            ITagData tagData = (ITagData)element;
            StyledString result = new StyledString();
            ITagset tagset = TagRep.getTagset((IStoryModel)this.getStoryEditor().getStoryModel());
            ITag iTag = tag = tagset == null ? null : tagset.getTag(tagData.getTagID());
            if (tag == null) {
                result.append("(id=", TAG_STYLER);
                result.append(tagData.getTagID(), TAG_STYLER);
                result.append("): ", TAG_STYLER);
            } else {
                result.append(tag.getName(), StyledString.COUNTER_STYLER);
                result.append(": ", StyledString.COUNTER_STYLER);
            }
            result.append(tagData.getDisplayText());
            if (desc != null) {
                TagDataLabelProvider.appendID((StyledString)result, (long)desc.getID());
                TagDataLabelProvider.appendMergeTags((StyledString)result, (IDesc)desc);
            }
            return result;
        }
        return super.getStyledText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc) {
            return this.getTagImg();
        }
        if (element instanceof ITagData) {
            return this.getTagImg();
        }
        return super.getImage(element);
    }

    protected Image getTagImg() {
        if (this.tagImg == null) {
            this.tagImg = ParsingUIPlugin.getDefault().getImageRegistry().get("obj16/tag.gif");
        }
        return this.tagImg;
    }
}

