/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.editor;

import edu.mit.story.ui.document.StoryDamagerRepairer;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryContentAssistProcessor;
import edu.mit.story.ui.editor.StoryEditorTextHover;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class StorySourceViewerConfiguration
extends SourceViewerConfiguration {
    static Color black = new Color((Device)Display.getDefault(), 0, 0, 0);
    static Color blue = new Color((Device)Display.getDefault(), 63, 95, 191);
    static ITokenScanner textScanner = new SingleTokenScanner(new TextAttribute(black));
    static ITokenScanner commentScanner = new SingleTokenScanner(new TextAttribute(blue));
    private IStoryEditor fEditor;
    private ITextHover textHover;
    private IAnnotationHover annoHover;

    public StorySourceViewerConfiguration(IStoryEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.fEditor = editor;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "story_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "text_content_type", "comment_content_type"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        StoryDamagerRepairer dr = new StoryDamagerRepairer(textScanner);
        reconciler.setDamager((IPresentationDamager)dr, "text_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "text_content_type");
        dr = new StoryDamagerRepairer(commentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "comment_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "comment_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        StoryContentAssistProcessor processor = new StoryContentAssistProcessor(this.fEditor);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "text_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "comment_content_type");
        return assistant;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.textHover == null) {
            this.textHover = new StoryEditorTextHover();
        }
        return this.textHover;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.annoHover == null) {
            this.annoHover = new DefaultAnnotationHover();
        }
        return this.annoHover;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

