/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions.editor;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.util.LogUtils;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class StoryEditorOperationHistoryAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final int MAX_LABEL_LENGTH = 32;
    private final IStoryEditor editor;
    private final IUndoableStoryModel model;
    private final IUndoContext viewerUndoContext;
    private final IUndoContext modelUndoContext;
    private final IPartListener partListener = new PartListener();
    private final IOperationHistoryListener historyListener = new HistoryListener();
    private IWorkbenchPartSite site;

    public StoryEditorOperationHistoryAction(IStoryEditor editor) {
        super("");
        this.editor = editor;
        this.model = editor.getStoryModel();
        this.modelUndoContext = this.model.getUndoContext();
        this.viewerUndoContext = editor.getViewerUndoContext();
        this.site = editor.getSite();
        this.site.getPage().addPartListener(this.partListener);
        this.getHistory().addOperationHistoryListener(this.historyListener);
        this.update();
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public IUndoableStoryModel getStoryModel() {
        return this.model;
    }

    public IUndoContext getModelUndoContext() {
        return this.modelUndoContext;
    }

    public IUndoContext getViewerUndoContext() {
        return this.viewerUndoContext;
    }

    public void dispose() {
        IOperationHistory history = this.getHistory();
        if (history != null) {
            history.removeOperationHistoryListener(this.historyListener);
        }
        if (this.site != null) {
            this.site.getPage().removePartListener(this.partListener);
        }
    }

    public boolean isDisposed() {
        return this.site == null;
    }

    protected abstract boolean shouldBeEnabled();

    protected abstract String getCommandString();

    protected abstract String getTooltipString();

    protected abstract String getSimpleCommandString();

    protected abstract String getSimpleTooltipString();

    protected abstract IUndoableOperation getOperation();

    protected abstract IStatus runCommand() throws ExecutionException;

    public final void run() {
        if (this.isDisposed()) {
            return;
        }
        Shell parent = this.getWorkbenchWindow().getShell();
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    StoryEditorOperationHistoryAction.this.runCommand();
                }
                catch (ExecutionException e) {
                    LogUtils.logError((Plugin)StoryPlugin.getDefault(), (Throwable)e);
                }
            }
        });
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.site != null ? this.site.getWorkbenchWindow() : null;
    }

    protected IOperationHistory getHistory() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    public void update() {
        String text;
        String tooltip;
        if (this.isDisposed()) {
            return;
        }
        boolean enabled = this.shouldBeEnabled();
        if (enabled) {
            tooltip = NLS.bind((String)this.getTooltipString(), (Object)this.getOperation().getLabel());
            text = NLS.bind((String)this.getCommandString(), (Object)StringUtils.shortenText((String)this.getOperation().getLabel(), (int)32));
        } else {
            tooltip = NLS.bind((String)"Can''t {0}", (Object)this.getSimpleTooltipString());
            text = this.getSimpleCommandString();
        }
        this.setText(text);
        this.setToolTipText(tooltip);
        this.setEnabled(enabled);
    }

    protected class HistoryListener
    implements IOperationHistoryListener {
        protected HistoryListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            Display display = StoryEditorOperationHistoryAction.this.getWorkbenchWindow().getWorkbench().getDisplay();
            switch (event.getEventType()) {
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (display == null || !event.getOperation().hasContext(StoryEditorOperationHistoryAction.this.modelUndoContext)) break;
                    display.asyncExec(new Runnable(){

                        public void run() {
                            StoryEditorOperationHistoryAction.this.update();
                        }
                    });
                    break;
                }
                case 6: {
                    if (display == null || event.getOperation() != StoryEditorOperationHistoryAction.this.getOperation()) break;
                    display.asyncExec(new Runnable(){

                        public void run() {
                            StoryEditorOperationHistoryAction.this.update();
                        }
                    });
                    break;
                }
            }
        }
    }

    protected class PartListener
    implements IPartListener {
        protected PartListener() {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part.equals(StoryEditorOperationHistoryAction.this.site.getPart())) {
                StoryEditorOperationHistoryAction.this.dispose();
            } else if (StoryEditorOperationHistoryAction.this.site instanceof MultiPageEditorSite && part.equals(((MultiPageEditorSite)StoryEditorOperationHistoryAction.this.site).getMultiPageEditor())) {
                StoryEditorOperationHistoryAction.this.dispose();
            }
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }
    }
}

