/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem;

import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.IStemData;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignStemChange
extends AbstractModelChange {
    private final long wordID;
    private final IStemData stemData;
    private final Set<ITiming> timings;

    public AssignStemChange(IStemData stemData, IDesc wordTarget, ITiming timing) {
        this(stemData, wordTarget.getID(), timing);
    }

    public AssignStemChange(IStemData stemData, long wordID, ITiming timing) {
        this(stemData, wordID, Collections.singleton(timing));
    }

    public AssignStemChange(IStemData stemData, IDesc wordTarget, Collection<? extends ITiming> timings) {
        this(stemData, wordTarget.getID(), timings);
    }

    public AssignStemChange(IStemData stemData, long wordID, Collection<? extends ITiming> timings) {
        super("Assign Stem");
        if (wordID < 0L) {
            throw new IllegalArgumentException();
        }
        this.stemData = stemData;
        this.wordID = wordID;
        this.timings = Collections.unmodifiableSet(new HashSet<ITiming>(timings));
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        boolean createStem;
        IDesc word = model.getData().getDescription(this.wordID);
        if (word == null) {
            return null;
        }
        String lemma = this.stemData == null ? null : this.stemData.getStem();
        DescSet stems = new DescSet(StemRep.getInstance());
        IDescSet ds = model.getData().getDescriptions(StemRep.getInstance()).matchSet((IHasPosition)word);
        IDesc chosen = null;
        for (IDesc d : ds) {
            IStem stem = (IStem)d.getData();
            if (stem.getWord().getID() != word.getID()) continue;
            if (chosen == null && stem.getStem().equals(lemma)) {
                chosen = d;
                continue;
            }
            stems.add((Object)d);
        }
        RemoveDescriptionsChange change = new RemoveDescriptionsChange((Collection)stems);
        IBaseToken token = (IBaseToken)word.getData();
        boolean bl = createStem = chosen == null && this.stemData != null && !token.getSurface().equalsIgnoreCase(this.stemData.getStem());
        if (createStem) {
            IData data = StemRep.getInstance().reconstitute((IHasPosition)word, this.stemData.getStem(), (IStoryModel)model);
            Desc newDesc = new Desc(model.getNextID(), StemRep.getInstance(), (IHasPosition)word, data, null);
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            for (ITiming timing : this.timings) {
                if (timing == null) continue;
                newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)timing));
            }
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
        }
        return change.apply(source, model);
    }
}

