/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.function;

import edu.mit.semantics.core.rep.function.IFunction;
import edu.mit.semantics.core.rep.function.IFunctionInstance;
import edu.mit.semantics.core.rep.function.IFunctionTag;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Data;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.ImmutableHasPositionSet;
import edu.mit.story.core.position.PositionUtils;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Function
implements IFunction {
    private final IFunctionTag tag;
    private final IHasPositionSet<IFunctionInstance> instances;
    private final IHasPosition pos;

    public Function(IFunctionTag tag, Collection<? extends IFunctionInstance> instances) {
        if (tag == null) {
            throw new NullPointerException();
        }
        if (instances.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.tag = tag;
        this.instances = new ImmutableHasPositionSet(instances);
        this.pos = PositionUtils.combineAll(instances);
    }

    @Override
    public IFunctionTag getFunctionTag() {
        return this.tag;
    }

    public IHasPositionSet<IFunctionInstance> getInstances() {
        return this.instances;
    }

    public IHasPosition calculatePosition() {
        return this.pos;
    }

    public IHasPosition getDisplayPosition() {
        return this.pos;
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        LinkedList<IFunctionInstance> newInstances = new LinkedList<IFunctionInstance>();
        boolean changed = false;
        for (IFunctionInstance oldInst : this.instances) {
            IFunctionInstance newInst = (IFunctionInstance)oldInst.recalculate(container, model);
            if (newInst != oldInst) {
                changed = true;
            }
            if (newInst == null) continue;
            newInstances.add(newInst);
        }
        if (newInstances.isEmpty()) {
            return null;
        }
        if (!changed) {
            return this;
        }
        return new Function(this.tag, newInstances);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!IFunction.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        IFunction tgtFunc = (IFunction)tgtData;
        if (!this.tag.equals(tgtFunc.getFunctionTag())) {
            return false;
        }
        return Data.equals(this.getInstances(), tgtFunc.getInstances(), (IAlignedStoryModel)model);
    }
}

