/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.relation;

import edu.mit.discourse.core.rep.relation.IAdjunct;
import edu.mit.discourse.core.rep.relation.IArgument;
import edu.mit.discourse.ui.relation.AdjunctProxy;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.util.IClearable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentProxy
extends AdjunctProxy
implements IArgument,
IClearable,
INotifyingMessageProvider {
    private String name;
    private final ChangeNotifier notifier = new ChangeNotifier();
    ListenerList listeners = new ListenerList();
    public final List<AdjunctProxy> adjuncts = new ArrayList<AdjunctProxy>();

    public ArgumentProxy() {
        this("An Argument");
    }

    public ArgumentProxy(String name) {
        this(name, Collections.emptyList(), false, null);
    }

    public ArgumentProxy(String name, Collection<ISegment> tokenSegments, boolean makeReferent, IStoryData data) {
        super(tokenSegments, makeReferent, data);
        this.name = name;
    }

    @Override
    public void load(AdjunctProxy proxy, IStoryData data) {
        this.internalClear();
        super.load(proxy, data);
        if (proxy instanceof ArgumentProxy) {
            ArgumentProxy argProxy = (ArgumentProxy)proxy;
            this.setName(argProxy.getName());
            this.adjuncts.addAll(argProxy.adjuncts);
        }
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public void setTokenSegments(Collection<ISegment> newSegments, IStoryData data) {
        this.tokenSegments.clear();
        for (ISegment segment : newSegments) {
            this.tokenSegments.add((Object)new Segment((IHasPosition)segment, segment.getRep(), data));
        }
        this.displayText = this.generateText(data);
        this.notifyChangeListeners(this);
    }

    public void addAdjunct(Collection<ISegment> tokenRanges, boolean makeReferent, IStoryData data) {
        AdjunctProxy proxy = new AdjunctProxy(tokenRanges, makeReferent, data);
        this.adjuncts.add(proxy);
        this.notifyChangeListeners(this);
    }

    public void setAdjuncts(List<AdjunctProxy> newAdjuncts) {
        this.adjuncts.clear();
        this.adjuncts.addAll(newAdjuncts);
        this.notifyChangeListeners(this);
    }

    public List<IAdjunct> getAdjuncts() {
        return new ArrayList<IAdjunct>(this.adjuncts);
    }

    @Override
    public void clear() {
        this.internalClear();
        this.notifyChangeListeners(this);
    }

    @Override
    public boolean isCleared() {
        return super.isCleared() && this.adjuncts.isEmpty();
    }

    protected void internalClear() {
        super.clear();
        this.adjuncts.clear();
    }

    public boolean validate() {
        return !this.tokenSegments.isEmpty();
    }

    public String getMessage() {
        return this.validate() ? null : String.valueOf(this.name) + " is not completely specified";
    }

    public int getMessageType() {
        return this.validate() ? 0 : 3;
    }

    public void notifyChangeListeners(Object source) {
        this.notifier.notifyChangeListeners(source);
    }

    public void addChangeListener(ChangeListener listener) {
        this.notifier.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.notifier.removeChangeListener(listener);
    }

    public static ArgumentProxy convert(IArgument arg, IStoryData data) {
        AdjunctProxy adjProxy = AdjunctProxy.convert((IAdjunct)arg, data);
        ArgumentProxy proxy = new ArgumentProxy("Lexical Marker");
        proxy.load(adjProxy, data);
        for (IAdjunct adj : arg.getAdjuncts()) {
            adjProxy = AdjunctProxy.convert(adj, data);
            proxy.adjuncts.add(adjProxy);
        }
        return proxy;
    }

    public void allowNotifications() {
        this.notifier.allowNotifications();
    }

    public void suppressNotifications() {
        this.notifier.suppressNotifications();
    }
}

