/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.model.RollbackProfileElement;
import org.eclipse.equinox.internal.provisional.p2.ui.model.RollbackRepositoryElement;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProfileModificationOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IQueryProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.RepositoryContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class RevertProfileWizardPage
extends WizardPage {
    private TableViewer configsViewer;
    private TableViewer configContentsViewer;
    String profileId;
    IQueryProvider queryProvider;
    private static final int DEFAULT_COLUMN_WIDTH = 150;
    static /* synthetic */ Class class$0;

    public RevertProfileWizardPage(String profileId, IQueryProvider queryProvider) {
        super("RevertConfiguration");
        this.setTitle(ProvUIMessages.RevertDialog_PageTitle);
        this.setDescription(ProvUIMessages.RevertDialog_Description);
        this.profileId = profileId;
        this.queryProvider = queryProvider;
    }

    public void createControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayout((Layout)new GridLayout());
        sashForm.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)sashForm);
        this.createConfigurationsSection((Composite)sashForm);
        this.createContentsSection((Composite)sashForm);
        this.setControl((Control)sashForm);
        Object element = this.configsViewer.getElementAt(0);
        if (element != null) {
            this.configsViewer.setSelection((ISelection)new StructuredSelection(element));
        }
        Dialog.applyDialogFont((Control)sashForm);
    }

    private void createConfigurationsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.RevertDialog_ConfigsLabel);
        this.configsViewer = new TableViewer(composite, 68352);
        this.configsViewer.setContentProvider((IContentProvider)new RepositoryContentProvider(this.queryProvider));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new ProvElementLabelProvider());
        this.configsViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IInstallableUnit iu1 = (IInstallableUnit)ProvUI.getAdapter(o1, clazz);
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IInstallableUnit iu2 = (IInstallableUnit)ProvUI.getAdapter(o2, clazz2);
                if (iu1 == null || iu2 == null) {
                    return o2.toString().compareTo(o1.toString());
                }
                return iu2.getVersion().compareTo((Object)iu1.getVersion());
            }
        });
        this.configsViewer.setInput(this.getInput());
        this.configsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RevertProfileWizardPage.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        gd = new GridData(1808);
        this.configsViewer.getControl().setLayoutData((Object)gd);
    }

    private void createContentsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.RevertDialog_ConfigContentsLabel);
        this.configContentsViewer = new TableViewer(composite, 68356);
        this.configContentsViewer.setComparator((ViewerComparator)new IUComparator(0));
        this.configContentsViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.configContentsViewer.setContentProvider((IContentProvider)new DeferredQueryContentProvider(this.queryProvider));
        this.setTableColumns(this.configContentsViewer.getTable());
        this.configContentsViewer.setLabelProvider((IBaseLabelProvider)new IUDetailsLabelProvider());
        gd = new GridData(1808);
        this.configContentsViewer.getControl().setLayoutData((Object)gd);
    }

    private Object getInput() {
        try {
            RollbackRepositoryElement element = new RollbackRepositoryElement(ProvisioningUtil.getRollbackRepositoryURL(), this.profileId);
            element.setQueryProvider(this.queryProvider);
            return element;
        }
        catch (ProvisionException e) {
            ProvUI.handleException(e, ProvUIMessages.RevertProfileWizardPage_ErrorRetrievingHistory, 5);
            return null;
        }
    }

    void handleSelectionChanged(IStructuredSelection selection) {
        Object selected;
        if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof RollbackProfileElement) {
            final IProfile[] snapshot = new IProfile[1];
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        snapshot[0] = ((RollbackProfileElement)selected).getProfileSnapshot(null);
                    }
                    catch (ProvisionException e) {
                        ProvUI.handleException(e, ProvUIMessages.RollbackProfileElement_InvalidSnapshot, 3);
                    }
                }
            });
            if (snapshot[0] != null) {
                this.configContentsViewer.setInput(selected);
                this.setPageComplete(true);
                return;
            }
        }
        this.configContentsViewer.setInput(null);
        this.setPageComplete(false);
    }

    private void setTableColumns(Table table) {
        IUColumnConfig[] columns = ProvUI.getIUColumnConfig();
        int i = 0;
        while (i < columns.length) {
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(true);
            tc.setText(columns[i].columnTitle);
            tc.setWidth(this.convertHorizontalDLUsToPixels(150));
            ++i;
        }
    }

    private IInstallableUnit getSelectedIU() {
        Object selected = ((IStructuredSelection)this.configsViewer.getSelection()).getFirstElement();
        if (selected != null && selected instanceof RollbackProfileElement) {
            return ((RollbackProfileElement)selected).getIU();
        }
        return null;
    }

    public boolean performFinish() {
        Shell shell = this.getContainer().getShell();
        boolean result = MessageDialog.openQuestion((Shell)shell, (String)shell.getText(), (String)ProvUIMessages.RevertDialog_ConfirmRestartMessage);
        if (!result) {
            return false;
        }
        boolean finish = this.revert();
        if (finish) {
            PlatformUI.getWorkbench().restart();
        }
        return finish;
    }

    private boolean revert() {
        block6: {
            ProvisioningPlan[] plan;
            block8: {
                block7: {
                    final IInstallableUnit iu = this.getSelectedIU();
                    if (iu == null) {
                        return false;
                    }
                    plan = new ProvisioningPlan[1];
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            try {
                                plan[0] = ProvisioningUtil.getRevertPlan(iu, monitor);
                            }
                            catch (ProvisionException e) {
                                plan[0] = null;
                                ProvUI.handleException(e.getCause(), ProvUIMessages.ProfileModificationWizardPage_UnexpectedError, 1);
                                RevertProfileWizardPage.this.setMessage(ProvUIMessages.ProfileModificationWizardPage_UnexpectedError, 3);
                            }
                        }
                    };
                    this.getContainer().run(true, true, runnable);
                    if (plan[0] == null) break block6;
                    if (!plan[0].getStatus().isOK()) break block7;
                    ProfileModificationOperation op = new ProfileModificationOperation(ProvUIMessages.RevertDialog_RevertOperationLabel, this.profileId, plan[0]);
                    ProvisioningOperationRunner.run(op, this.getShell(), 3);
                    return true;
                }
                if (plan[0].getStatus().getSeverity() != 8) break block8;
                return false;
            }
            try {
                ProvUI.reportStatus(plan[0].getStatus(), 1);
                this.setMessage(ProvUIMessages.ProfileModificationWizardPage_UnexpectedError, 3);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                ProvUI.handleException(e.getCause(), ProvUIMessages.RevertDialog_RevertError, 1);
                this.setMessage(ProvUIMessages.RevertDialog_RevertError, 3);
            }
        }
        return false;
    }
}

